<?php
namespace SlickMenu\Elementor;

use Elementor\Controls_Manager;
use Elementor\Widget_Icon;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Elementor Quick View Widget.
 *
 * Elementor widget that inserts a quick view button into the page, from any given product id.
 *
 * @since 1.0.0
 */
class Trigger_Icon_Widget extends Widget_Icon {

    /**
	 * Get widget name.
	 *
	 * Retrieve widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'slick-menu-trigger-icon';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Slick Menu Trigger Icon', 'slick-menu' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

    /**
     * Get custom help URL.
     *
     * Retrieve a URL where the user can get more information about the widget.
     *
     * @since 1.0.0
     * @access public
     * @return string Widget help URL.
     */
    public function get_custom_help_url() {
        return 'https://slickmenu.net';
    }

    /**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'slick-menu' ];
	}


    /**
     * Get widget keywords.
     *
     * Retrieve the list of keywords the oEmbed widget belongs to.
     *
     * @since 1.0.0
     * @access public
     * @return array Widget keywords.
     */
    public function get_keywords() {
        return [ 'slick', 'menu', 'slickmenu' ];
    }

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {


        $this->start_controls_section(
            'section_slick_menu',
            [
                'label' => esc_html__( 'Slick Menu', 'slick-menu' ),
            ]
        );

        $this->add_control(
            'sm_menu_id',
            [
                'label' => esc_html__( 'Select Slick Menu', 'slick-menu' ),
                'description' => esc_html__( 'Note: The menu will not be triggered within elementor. Please test in preview mode.', 'slick-menu' ),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => Slick_Menu()->get_menus_dropdown_options()
            ]
        );

        $this->end_controls_section();

        parent::register_controls();

        $this->update_control('link', array(
            'type' => Controls_Manager::HIDDEN,
            'default' => array(
                'url' => '#'
            ),
        ));
    }

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

        if ( empty( $instance ) ) {
            $instance = $this;
        }

        $menu_id = $instance->get_settings_for_display('sm_menu_id');

        if(!empty($menu_id)) {

            $instance->add_render_attribute('icon-wrapper', 'class', 'sm-trigger sm-trigger-' . $menu_id);
            parent::render();
        }else{
            return __('Please select a Slick Menu!', 'slick-menu');
        }
	}
}
